﻿using System;
using System.Reflection;
using System.Reflection.Emit;

/// <summary>
///     Użycie API Reflection Emit
/// </summary>
class Emit
{
    static void Main(string[] args)
    {
        AppDomain myAppDomain = AppDomain.CurrentDomain;

        AssemblyName myAssemblyName = new AssemblyName();
        myAssemblyName.Name = "DynamicAssembly";

        AssemblyBuilder myAssemblyBuilder =
            myAppDomain.DefineDynamicAssembly(
            myAssemblyName,
            AssemblyBuilderAccess.RunAndSave);

        ModuleBuilder myModuleBuilder =
            myAssemblyBuilder.DefineDynamicModule(
            "DynamicModule",
            "emitter.netmodule");

        TypeBuilder myTypeBuilder =
            myModuleBuilder.DefineType(
            "EmitTestClass");

        MethodBuilder myMethodBuilder =
            myTypeBuilder.DefineMethod(
            "Main",
            MethodAttributes.Public | MethodAttributes.Static,
            null,
            null);

        ILGenerator myILGenerator
            = myMethodBuilder.GetILGenerator();
        myILGenerator.EmitWriteLine(
            "\n\tMuszę to powiedzieć: mechanizm refleksji jest świetny!\n");
        myILGenerator.Emit(OpCodes.Ret);

        Type myType = myTypeBuilder.CreateType();
        object myObjectInstance
            = Activator.CreateInstance(myType);

        Console.WriteLine("\nWywołanie dynamiczne:");

        MethodInfo myMethod = myType.GetMethod("Main");
        myMethod.Invoke(myObjectInstance, null);

        myAssemblyBuilder.SetEntryPoint(myMethod);
        myAssemblyBuilder.Save("emitter.exe");

        Console.ReadKey();
    }
}
